# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class UncompleteTaskRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.task_id: Optional[str] = None

    @staticmethod
    def builder() -> "UncompleteTaskRequestBuilder":
        return UncompleteTaskRequestBuilder()


class UncompleteTaskRequestBuilder(object):

    def __init__(self) -> None:
        uncomplete_task_request = UncompleteTaskRequest()
        uncomplete_task_request.http_method = HttpMethod.POST
        uncomplete_task_request.uri = "/open-apis/task/v1/tasks/:task_id/uncomplete"
        uncomplete_task_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._uncomplete_task_request: UncompleteTaskRequest = uncomplete_task_request

    def task_id(self, task_id: str) -> "UncompleteTaskRequestBuilder":
        self._uncomplete_task_request.task_id = task_id
        self._uncomplete_task_request.paths["task_id"] = str(task_id)
        return self

    def build(self) -> UncompleteTaskRequest:
        return self._uncomplete_task_request
