# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .update_task_comment_request_body import UpdateTaskCommentRequestBody


class UpdateTaskCommentRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.task_id: Optional[str] = None
        self.comment_id: Optional[int] = None
        self.request_body: Optional[UpdateTaskCommentRequestBody] = None

    @staticmethod
    def builder() -> "UpdateTaskCommentRequestBuilder":
        return UpdateTaskCommentRequestBuilder()


class UpdateTaskCommentRequestBuilder(object):

    def __init__(self) -> None:
        update_task_comment_request = UpdateTaskCommentRequest()
        update_task_comment_request.http_method = HttpMethod.PUT
        update_task_comment_request.uri = "/open-apis/task/v1/tasks/:task_id/comments/:comment_id"
        update_task_comment_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._update_task_comment_request: UpdateTaskCommentRequest = update_task_comment_request

    def user_id_type(self, user_id_type: str) -> "UpdateTaskCommentRequestBuilder":
        self._update_task_comment_request.user_id_type = user_id_type
        self._update_task_comment_request.add_query("user_id_type", user_id_type)
        return self

    def task_id(self, task_id: str) -> "UpdateTaskCommentRequestBuilder":
        self._update_task_comment_request.task_id = task_id
        self._update_task_comment_request.paths["task_id"] = str(task_id)
        return self

    def comment_id(self, comment_id: int) -> "UpdateTaskCommentRequestBuilder":
        self._update_task_comment_request.comment_id = comment_id
        self._update_task_comment_request.paths["comment_id"] = str(comment_id)
        return self

    def request_body(self, request_body: UpdateTaskCommentRequestBody) -> "UpdateTaskCommentRequestBuilder":
        self._update_task_comment_request.request_body = request_body
        self._update_task_comment_request.body = request_body
        return self

    def build(self) -> UpdateTaskCommentRequest:
        return self._update_task_comment_request
