# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_task_collaborator_request import CreateTaskCollaboratorRequest
from ..model.create_task_collaborator_response import CreateTaskCollaboratorResponse
from ..model.delete_task_collaborator_request import DeleteTaskCollaboratorRequest
from ..model.delete_task_collaborator_response import DeleteTaskCollaboratorResponse
from ..model.list_task_collaborator_request import ListTaskCollaboratorRequest
from ..model.list_task_collaborator_response import ListTaskCollaboratorResponse


class TaskCollaborator(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreateTaskCollaboratorRequest,
               option: Optional[RequestOption] = None) -> CreateTaskCollaboratorResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateTaskCollaboratorResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                  CreateTaskCollaboratorResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateTaskCollaboratorRequest,
                      option: Optional[RequestOption] = None) -> CreateTaskCollaboratorResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateTaskCollaboratorResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                  CreateTaskCollaboratorResponse)
        response.raw = resp

        return response

    def delete(self, request: DeleteTaskCollaboratorRequest,
               option: Optional[RequestOption] = None) -> DeleteTaskCollaboratorResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteTaskCollaboratorResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                  DeleteTaskCollaboratorResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeleteTaskCollaboratorRequest,
                      option: Optional[RequestOption] = None) -> DeleteTaskCollaboratorResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteTaskCollaboratorResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                  DeleteTaskCollaboratorResponse)
        response.raw = resp

        return response

    def list(self, request: ListTaskCollaboratorRequest,
             option: Optional[RequestOption] = None) -> ListTaskCollaboratorResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListTaskCollaboratorResponse = JSON.unmarshal(str(resp.content, UTF_8), ListTaskCollaboratorResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListTaskCollaboratorRequest,
                    option: Optional[RequestOption] = None) -> ListTaskCollaboratorResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListTaskCollaboratorResponse = JSON.unmarshal(str(resp.content, UTF_8), ListTaskCollaboratorResponse)
        response.raw = resp

        return response
