# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_task_reminder_request import CreateTaskReminderRequest
from ..model.create_task_reminder_response import CreateTaskReminderResponse
from ..model.delete_task_reminder_request import DeleteTaskReminderRequest
from ..model.delete_task_reminder_response import DeleteTaskReminderResponse
from ..model.list_task_reminder_request import ListTaskReminderRequest
from ..model.list_task_reminder_response import ListTaskReminderResponse


class TaskReminder(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreateTaskReminderRequest,
               option: Optional[RequestOption] = None) -> CreateTaskReminderResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateTaskReminderResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateTaskReminderResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateTaskReminderRequest,
                      option: Optional[RequestOption] = None) -> CreateTaskReminderResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateTaskReminderResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateTaskReminderResponse)
        response.raw = resp

        return response

    def delete(self, request: DeleteTaskReminderRequest,
               option: Optional[RequestOption] = None) -> DeleteTaskReminderResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteTaskReminderResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteTaskReminderResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeleteTaskReminderRequest,
                      option: Optional[RequestOption] = None) -> DeleteTaskReminderResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteTaskReminderResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteTaskReminderResponse)
        response.raw = resp

        return response

    def list(self, request: ListTaskReminderRequest,
             option: Optional[RequestOption] = None) -> ListTaskReminderResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListTaskReminderResponse = JSON.unmarshal(str(resp.content, UTF_8), ListTaskReminderResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListTaskReminderRequest,
                    option: Optional[RequestOption] = None) -> ListTaskReminderResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListTaskReminderResponse = JSON.unmarshal(str(resp.content, UTF_8), ListTaskReminderResponse)
        response.raw = resp

        return response
