# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .add_dependencies_task_request_body import AddDependenciesTaskRequestBody


class AddDependenciesTaskRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.task_guid: Optional[str] = None
        self.request_body: Optional[AddDependenciesTaskRequestBody] = None

    @staticmethod
    def builder() -> "AddDependenciesTaskRequestBuilder":
        return AddDependenciesTaskRequestBuilder()


class AddDependenciesTaskRequestBuilder(object):

    def __init__(self) -> None:
        add_dependencies_task_request = AddDependenciesTaskRequest()
        add_dependencies_task_request.http_method = HttpMethod.POST
        add_dependencies_task_request.uri = "/open-apis/task/v2/tasks/:task_guid/add_dependencies"
        add_dependencies_task_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._add_dependencies_task_request: AddDependenciesTaskRequest = add_dependencies_task_request

    def task_guid(self, task_guid: str) -> "AddDependenciesTaskRequestBuilder":
        self._add_dependencies_task_request.task_guid = task_guid
        self._add_dependencies_task_request.paths["task_guid"] = str(task_guid)
        return self

    def request_body(self, request_body: AddDependenciesTaskRequestBody) -> "AddDependenciesTaskRequestBuilder":
        self._add_dependencies_task_request.request_body = request_body
        self._add_dependencies_task_request.body = request_body
        return self

    def build(self) -> AddDependenciesTaskRequest:
        return self._add_dependencies_task_request
