# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .member import Member


class AddMembersTaskRequestBody(object):
    _types = {
        "members": List[Member],
        "client_token": str,
    }

    def __init__(self, d=None):
        self.members: Optional[List[Member]] = None
        self.client_token: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AddMembersTaskRequestBodyBuilder":
        return AddMembersTaskRequestBodyBuilder()


class AddMembersTaskRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._add_members_task_request_body = AddMembersTaskRequestBody()

    def members(self, members: List[Member]) -> "AddMembersTaskRequestBodyBuilder":
        self._add_members_task_request_body.members = members
        return self

    def client_token(self, client_token: str) -> "AddMembersTaskRequestBodyBuilder":
        self._add_members_task_request_body.client_token = client_token
        return self

    def build(self) -> "AddMembersTaskRequestBody":
        return self._add_members_task_request_body
