# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .add_members_tasklist_request_body import AddMembersTasklistRequestBody


class AddMembersTasklistRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.tasklist_guid: Optional[str] = None
        self.request_body: Optional[AddMembersTasklistRequestBody] = None

    @staticmethod
    def builder() -> "AddMembersTasklistRequestBuilder":
        return AddMembersTasklistRequestBuilder()


class AddMembersTasklistRequestBuilder(object):

    def __init__(self) -> None:
        add_members_tasklist_request = AddMembersTasklistRequest()
        add_members_tasklist_request.http_method = HttpMethod.POST
        add_members_tasklist_request.uri = "/open-apis/task/v2/tasklists/:tasklist_guid/add_members"
        add_members_tasklist_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._add_members_tasklist_request: AddMembersTasklistRequest = add_members_tasklist_request

    def user_id_type(self, user_id_type: str) -> "AddMembersTasklistRequestBuilder":
        self._add_members_tasklist_request.user_id_type = user_id_type
        self._add_members_tasklist_request.add_query("user_id_type", user_id_type)
        return self

    def tasklist_guid(self, tasklist_guid: str) -> "AddMembersTasklistRequestBuilder":
        self._add_members_tasklist_request.tasklist_guid = tasklist_guid
        self._add_members_tasklist_request.paths["tasklist_guid"] = str(tasklist_guid)
        return self

    def request_body(self, request_body: AddMembersTasklistRequestBody) -> "AddMembersTasklistRequestBuilder":
        self._add_members_tasklist_request.request_body = request_body
        self._add_members_tasklist_request.body = request_body
        return self

    def build(self) -> AddMembersTasklistRequest:
        return self._add_members_tasklist_request
