# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .input_comment import InputComment


class CreateCommentRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.request_body: Optional[InputComment] = None

    @staticmethod
    def builder() -> "CreateCommentRequestBuilder":
        return CreateCommentRequestBuilder()


class CreateCommentRequestBuilder(object):

    def __init__(self) -> None:
        create_comment_request = CreateCommentRequest()
        create_comment_request.http_method = HttpMethod.POST
        create_comment_request.uri = "/open-apis/task/v2/comments"
        create_comment_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._create_comment_request: CreateCommentRequest = create_comment_request

    def user_id_type(self, user_id_type: str) -> "CreateCommentRequestBuilder":
        self._create_comment_request.user_id_type = user_id_type
        self._create_comment_request.add_query("user_id_type", user_id_type)
        return self

    def request_body(self, request_body: InputComment) -> "CreateCommentRequestBuilder":
        self._create_comment_request.request_body = request_body
        self._create_comment_request.body = request_body
        return self

    def build(self) -> CreateCommentRequest:
        return self._create_comment_request
