# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .input_option import InputOption


class CreateCustomFieldOptionRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.custom_field_guid: Optional[str] = None
        self.request_body: Optional[InputOption] = None

    @staticmethod
    def builder() -> "CreateCustomFieldOptionRequestBuilder":
        return CreateCustomFieldOptionRequestBuilder()


class CreateCustomFieldOptionRequestBuilder(object):

    def __init__(self) -> None:
        create_custom_field_option_request = CreateCustomFieldOptionRequest()
        create_custom_field_option_request.http_method = HttpMethod.POST
        create_custom_field_option_request.uri = "/open-apis/task/v2/custom_fields/:custom_field_guid/options"
        create_custom_field_option_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._create_custom_field_option_request: CreateCustomFieldOptionRequest = create_custom_field_option_request

    def custom_field_guid(self, custom_field_guid: str) -> "CreateCustomFieldOptionRequestBuilder":
        self._create_custom_field_option_request.custom_field_guid = custom_field_guid
        self._create_custom_field_option_request.paths["custom_field_guid"] = str(custom_field_guid)
        return self

    def request_body(self, request_body: InputOption) -> "CreateCustomFieldOptionRequestBuilder":
        self._create_custom_field_option_request.request_body = request_body
        self._create_custom_field_option_request.body = request_body
        return self

    def build(self) -> CreateCustomFieldOptionRequest:
        return self._create_custom_field_option_request
