# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .input_section import InputSection


class CreateSectionRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.request_body: Optional[InputSection] = None

    @staticmethod
    def builder() -> "CreateSectionRequestBuilder":
        return CreateSectionRequestBuilder()


class CreateSectionRequestBuilder(object):

    def __init__(self) -> None:
        create_section_request = CreateSectionRequest()
        create_section_request.http_method = HttpMethod.POST
        create_section_request.uri = "/open-apis/task/v2/sections"
        create_section_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._create_section_request: CreateSectionRequest = create_section_request

    def user_id_type(self, user_id_type: str) -> "CreateSectionRequestBuilder":
        self._create_section_request.user_id_type = user_id_type
        self._create_section_request.add_query("user_id_type", user_id_type)
        return self

    def request_body(self, request_body: InputSection) -> "CreateSectionRequestBuilder":
        self._create_section_request.request_body = request_body
        self._create_section_request.body = request_body
        return self

    def build(self) -> CreateSectionRequest:
        return self._create_section_request
