# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .input_task import InputTask


class CreateTaskSubtaskRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.task_guid: Optional[str] = None
        self.request_body: Optional[InputTask] = None

    @staticmethod
    def builder() -> "CreateTaskSubtaskRequestBuilder":
        return CreateTaskSubtaskRequestBuilder()


class CreateTaskSubtaskRequestBuilder(object):

    def __init__(self) -> None:
        create_task_subtask_request = CreateTaskSubtaskRequest()
        create_task_subtask_request.http_method = HttpMethod.POST
        create_task_subtask_request.uri = "/open-apis/task/v2/tasks/:task_guid/subtasks"
        create_task_subtask_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._create_task_subtask_request: CreateTaskSubtaskRequest = create_task_subtask_request

    def user_id_type(self, user_id_type: str) -> "CreateTaskSubtaskRequestBuilder":
        self._create_task_subtask_request.user_id_type = user_id_type
        self._create_task_subtask_request.add_query("user_id_type", user_id_type)
        return self

    def task_guid(self, task_guid: str) -> "CreateTaskSubtaskRequestBuilder":
        self._create_task_subtask_request.task_guid = task_guid
        self._create_task_subtask_request.paths["task_guid"] = str(task_guid)
        return self

    def request_body(self, request_body: InputTask) -> "CreateTaskSubtaskRequestBuilder":
        self._create_task_subtask_request.request_body = request_body
        self._create_task_subtask_request.body = request_body
        return self

    def build(self) -> CreateTaskSubtaskRequest:
        return self._create_task_subtask_request
