# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .input_tasklist import InputTasklist


class CreateTasklistRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.request_body: Optional[InputTasklist] = None

    @staticmethod
    def builder() -> "CreateTasklistRequestBuilder":
        return CreateTasklistRequestBuilder()


class CreateTasklistRequestBuilder(object):

    def __init__(self) -> None:
        create_tasklist_request = CreateTasklistRequest()
        create_tasklist_request.http_method = HttpMethod.POST
        create_tasklist_request.uri = "/open-apis/task/v2/tasklists"
        create_tasklist_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._create_tasklist_request: CreateTasklistRequest = create_tasklist_request

    def user_id_type(self, user_id_type: str) -> "CreateTasklistRequestBuilder":
        self._create_tasklist_request.user_id_type = user_id_type
        self._create_tasklist_request.add_query("user_id_type", user_id_type)
        return self

    def request_body(self, request_body: InputTasklist) -> "CreateTasklistRequestBuilder":
        self._create_tasklist_request.request_body = request_body
        self._create_tasklist_request.body = request_body
        return self

    def build(self) -> CreateTasklistRequest:
        return self._create_tasklist_request
