# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .custom_complete_item import CustomCompleteItem


class CustomComplete(object):
    _types = {
        "pc": CustomCompleteItem,
        "ios": CustomCompleteItem,
        "android": CustomCompleteItem,
    }

    def __init__(self, d=None):
        self.pc: Optional[CustomCompleteItem] = None
        self.ios: Optional[CustomCompleteItem] = None
        self.android: Optional[CustomCompleteItem] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CustomCompleteBuilder":
        return CustomCompleteBuilder()


class CustomCompleteBuilder(object):
    def __init__(self) -> None:
        self._custom_complete = CustomComplete()

    def pc(self, pc: CustomCompleteItem) -> "CustomCompleteBuilder":
        self._custom_complete.pc = pc
        return self

    def ios(self, ios: CustomCompleteItem) -> "CustomCompleteBuilder":
        self._custom_complete.ios = ios
        return self

    def android(self, android: CustomCompleteItem) -> "CustomCompleteBuilder":
        self._custom_complete.android = android
        return self

    def build(self) -> "CustomComplete":
        return self._custom_complete
