# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .i18n_text import I18nText


class CustomCompleteItem(object):
    _types = {
        "href": str,
        "tip": I18nText,
    }

    def __init__(self, d=None):
        self.href: Optional[str] = None
        self.tip: Optional[I18nText] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CustomCompleteItemBuilder":
        return CustomCompleteItemBuilder()


class CustomCompleteItemBuilder(object):
    def __init__(self) -> None:
        self._custom_complete_item = CustomCompleteItem()

    def href(self, href: str) -> "CustomCompleteItemBuilder":
        self._custom_complete_item.href = href
        return self

    def tip(self, tip: I18nText) -> "CustomCompleteItemBuilder":
        self._custom_complete_item.tip = tip
        return self

    def build(self) -> "CustomCompleteItem":
        return self._custom_complete_item
