# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .datetime_setting import DatetimeSetting
from .member import Member
from .member_setting import MemberSetting
from .number_setting import NumberSetting
from .select_setting import SelectSetting
from .text_setting import TextSetting


class CustomField(object):
    _types = {
        "guid": str,
        "name": str,
        "type": str,
        "number_setting": NumberSetting,
        "member_setting": MemberSetting,
        "datetime_setting": DatetimeSetting,
        "single_select_setting": SelectSetting,
        "multi_select_setting": SelectSetting,
        "creator": Member,
        "created_at": str,
        "updated_at": str,
        "text_setting": TextSetting,
    }

    def __init__(self, d=None):
        self.guid: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.number_setting: Optional[NumberSetting] = None
        self.member_setting: Optional[MemberSetting] = None
        self.datetime_setting: Optional[DatetimeSetting] = None
        self.single_select_setting: Optional[SelectSetting] = None
        self.multi_select_setting: Optional[SelectSetting] = None
        self.creator: Optional[Member] = None
        self.created_at: Optional[str] = None
        self.updated_at: Optional[str] = None
        self.text_setting: Optional[TextSetting] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CustomFieldBuilder":
        return CustomFieldBuilder()


class CustomFieldBuilder(object):
    def __init__(self) -> None:
        self._custom_field = CustomField()

    def guid(self, guid: str) -> "CustomFieldBuilder":
        self._custom_field.guid = guid
        return self

    def name(self, name: str) -> "CustomFieldBuilder":
        self._custom_field.name = name
        return self

    def type(self, type: str) -> "CustomFieldBuilder":
        self._custom_field.type = type
        return self

    def number_setting(self, number_setting: NumberSetting) -> "CustomFieldBuilder":
        self._custom_field.number_setting = number_setting
        return self

    def member_setting(self, member_setting: MemberSetting) -> "CustomFieldBuilder":
        self._custom_field.member_setting = member_setting
        return self

    def datetime_setting(self, datetime_setting: DatetimeSetting) -> "CustomFieldBuilder":
        self._custom_field.datetime_setting = datetime_setting
        return self

    def single_select_setting(self, single_select_setting: SelectSetting) -> "CustomFieldBuilder":
        self._custom_field.single_select_setting = single_select_setting
        return self

    def multi_select_setting(self, multi_select_setting: SelectSetting) -> "CustomFieldBuilder":
        self._custom_field.multi_select_setting = multi_select_setting
        return self

    def creator(self, creator: Member) -> "CustomFieldBuilder":
        self._custom_field.creator = creator
        return self

    def created_at(self, created_at: str) -> "CustomFieldBuilder":
        self._custom_field.created_at = created_at
        return self

    def updated_at(self, updated_at: str) -> "CustomFieldBuilder":
        self._custom_field.updated_at = updated_at
        return self

    def text_setting(self, text_setting: TextSetting) -> "CustomFieldBuilder":
        self._custom_field.text_setting = text_setting
        return self

    def build(self) -> "CustomField":
        return self._custom_field
