# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .member import Member


class CustomFieldValue(object):
    _types = {
        "guid": str,
        "type": str,
        "number_value": str,
        "datetime_value": str,
        "member_value": List[Member],
        "single_select_value": str,
        "multi_select_value": List[str],
        "name": str,
        "text_value": str,
    }

    def __init__(self, d=None):
        self.guid: Optional[str] = None
        self.type: Optional[str] = None
        self.number_value: Optional[str] = None
        self.datetime_value: Optional[str] = None
        self.member_value: Optional[List[Member]] = None
        self.single_select_value: Optional[str] = None
        self.multi_select_value: Optional[List[str]] = None
        self.name: Optional[str] = None
        self.text_value: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CustomFieldValueBuilder":
        return CustomFieldValueBuilder()


class CustomFieldValueBuilder(object):
    def __init__(self) -> None:
        self._custom_field_value = CustomFieldValue()

    def guid(self, guid: str) -> "CustomFieldValueBuilder":
        self._custom_field_value.guid = guid
        return self

    def type(self, type: str) -> "CustomFieldValueBuilder":
        self._custom_field_value.type = type
        return self

    def number_value(self, number_value: str) -> "CustomFieldValueBuilder":
        self._custom_field_value.number_value = number_value
        return self

    def datetime_value(self, datetime_value: str) -> "CustomFieldValueBuilder":
        self._custom_field_value.datetime_value = datetime_value
        return self

    def member_value(self, member_value: List[Member]) -> "CustomFieldValueBuilder":
        self._custom_field_value.member_value = member_value
        return self

    def single_select_value(self, single_select_value: str) -> "CustomFieldValueBuilder":
        self._custom_field_value.single_select_value = single_select_value
        return self

    def multi_select_value(self, multi_select_value: List[str]) -> "CustomFieldValueBuilder":
        self._custom_field_value.multi_select_value = multi_select_value
        return self

    def name(self, name: str) -> "CustomFieldValueBuilder":
        self._custom_field_value.name = name
        return self

    def text_value(self, text_value: str) -> "CustomFieldValueBuilder":
        self._custom_field_value.text_value = text_value
        return self

    def build(self) -> "CustomFieldValue":
        return self._custom_field_value
