# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class DeleteAttachmentRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.attachment_guid: Optional[str] = None

    @staticmethod
    def builder() -> "DeleteAttachmentRequestBuilder":
        return DeleteAttachmentRequestBuilder()


class DeleteAttachmentRequestBuilder(object):

    def __init__(self) -> None:
        delete_attachment_request = DeleteAttachmentRequest()
        delete_attachment_request.http_method = HttpMethod.DELETE
        delete_attachment_request.uri = "/open-apis/task/v2/attachments/:attachment_guid"
        delete_attachment_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._delete_attachment_request: DeleteAttachmentRequest = delete_attachment_request

    def attachment_guid(self, attachment_guid: str) -> "DeleteAttachmentRequestBuilder":
        self._delete_attachment_request.attachment_guid = attachment_guid
        self._delete_attachment_request.paths["attachment_guid"] = str(attachment_guid)
        return self

    def build(self) -> DeleteAttachmentRequest:
        return self._delete_attachment_request
