# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class DeleteCommentRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.comment_id: Optional[str] = None

    @staticmethod
    def builder() -> "DeleteCommentRequestBuilder":
        return DeleteCommentRequestBuilder()


class DeleteCommentRequestBuilder(object):

    def __init__(self) -> None:
        delete_comment_request = DeleteCommentRequest()
        delete_comment_request.http_method = HttpMethod.DELETE
        delete_comment_request.uri = "/open-apis/task/v2/comments/:comment_id"
        delete_comment_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._delete_comment_request: DeleteCommentRequest = delete_comment_request

    def comment_id(self, comment_id: str) -> "DeleteCommentRequestBuilder":
        self._delete_comment_request.comment_id = comment_id
        self._delete_comment_request.paths["comment_id"] = str(comment_id)
        return self

    def build(self) -> DeleteCommentRequest:
        return self._delete_comment_request
