# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class DeleteSectionRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.section_guid: Optional[str] = None

    @staticmethod
    def builder() -> "DeleteSectionRequestBuilder":
        return DeleteSectionRequestBuilder()


class DeleteSectionRequestBuilder(object):

    def __init__(self) -> None:
        delete_section_request = DeleteSectionRequest()
        delete_section_request.http_method = HttpMethod.DELETE
        delete_section_request.uri = "/open-apis/task/v2/sections/:section_guid"
        delete_section_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._delete_section_request: DeleteSectionRequest = delete_section_request

    def section_guid(self, section_guid: str) -> "DeleteSectionRequestBuilder":
        self._delete_section_request.section_guid = section_guid
        self._delete_section_request.paths["section_guid"] = str(section_guid)
        return self

    def build(self) -> DeleteSectionRequest:
        return self._delete_section_request
