# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetCommentRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.comment_id: Optional[str] = None

    @staticmethod
    def builder() -> "GetCommentRequestBuilder":
        return GetCommentRequestBuilder()


class GetCommentRequestBuilder(object):

    def __init__(self) -> None:
        get_comment_request = GetCommentRequest()
        get_comment_request.http_method = HttpMethod.GET
        get_comment_request.uri = "/open-apis/task/v2/comments/:comment_id"
        get_comment_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._get_comment_request: GetCommentRequest = get_comment_request

    def user_id_type(self, user_id_type: str) -> "GetCommentRequestBuilder":
        self._get_comment_request.user_id_type = user_id_type
        self._get_comment_request.add_query("user_id_type", user_id_type)
        return self

    def comment_id(self, comment_id: str) -> "GetCommentRequestBuilder":
        self._get_comment_request.comment_id = comment_id
        self._get_comment_request.paths["comment_id"] = str(comment_id)
        return self

    def build(self) -> GetCommentRequest:
        return self._get_comment_request
