# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetCustomFieldRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.custom_field_guid: Optional[str] = None

    @staticmethod
    def builder() -> "GetCustomFieldRequestBuilder":
        return GetCustomFieldRequestBuilder()


class GetCustomFieldRequestBuilder(object):

    def __init__(self) -> None:
        get_custom_field_request = GetCustomFieldRequest()
        get_custom_field_request.http_method = HttpMethod.GET
        get_custom_field_request.uri = "/open-apis/task/v2/custom_fields/:custom_field_guid"
        get_custom_field_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._get_custom_field_request: GetCustomFieldRequest = get_custom_field_request

    def user_id_type(self, user_id_type: str) -> "GetCustomFieldRequestBuilder":
        self._get_custom_field_request.user_id_type = user_id_type
        self._get_custom_field_request.add_query("user_id_type", user_id_type)
        return self

    def custom_field_guid(self, custom_field_guid: str) -> "GetCustomFieldRequestBuilder":
        self._get_custom_field_request.custom_field_guid = custom_field_guid
        self._get_custom_field_request.paths["custom_field_guid"] = str(custom_field_guid)
        return self

    def build(self) -> GetCustomFieldRequest:
        return self._get_custom_field_request
