# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetSectionRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.section_guid: Optional[str] = None

    @staticmethod
    def builder() -> "GetSectionRequestBuilder":
        return GetSectionRequestBuilder()


class GetSectionRequestBuilder(object):

    def __init__(self) -> None:
        get_section_request = GetSectionRequest()
        get_section_request.http_method = HttpMethod.GET
        get_section_request.uri = "/open-apis/task/v2/sections/:section_guid"
        get_section_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._get_section_request: GetSectionRequest = get_section_request

    def user_id_type(self, user_id_type: str) -> "GetSectionRequestBuilder":
        self._get_section_request.user_id_type = user_id_type
        self._get_section_request.add_query("user_id_type", user_id_type)
        return self

    def section_guid(self, section_guid: str) -> "GetSectionRequestBuilder":
        self._get_section_request.section_guid = section_guid
        self._get_section_request.paths["section_guid"] = str(section_guid)
        return self

    def build(self) -> GetSectionRequest:
        return self._get_section_request
