# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class I18nText(object):
    _types = {
        "en_us": str,
        "zh_cn": str,
        "zh_hk": str,
        "zh_tw": str,
        "ja_jp": str,
        "fr_fr": str,
        "it_it": str,
        "de_de": str,
        "ru_ru": str,
        "th_th": str,
        "es_es": str,
        "ko_kr": str,
    }

    def __init__(self, d=None):
        self.en_us: Optional[str] = None
        self.zh_cn: Optional[str] = None
        self.zh_hk: Optional[str] = None
        self.zh_tw: Optional[str] = None
        self.ja_jp: Optional[str] = None
        self.fr_fr: Optional[str] = None
        self.it_it: Optional[str] = None
        self.de_de: Optional[str] = None
        self.ru_ru: Optional[str] = None
        self.th_th: Optional[str] = None
        self.es_es: Optional[str] = None
        self.ko_kr: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "I18nTextBuilder":
        return I18nTextBuilder()


class I18nTextBuilder(object):
    def __init__(self) -> None:
        self._i18n_text = I18nText()

    def en_us(self, en_us: str) -> "I18nTextBuilder":
        self._i18n_text.en_us = en_us
        return self

    def zh_cn(self, zh_cn: str) -> "I18nTextBuilder":
        self._i18n_text.zh_cn = zh_cn
        return self

    def zh_hk(self, zh_hk: str) -> "I18nTextBuilder":
        self._i18n_text.zh_hk = zh_hk
        return self

    def zh_tw(self, zh_tw: str) -> "I18nTextBuilder":
        self._i18n_text.zh_tw = zh_tw
        return self

    def ja_jp(self, ja_jp: str) -> "I18nTextBuilder":
        self._i18n_text.ja_jp = ja_jp
        return self

    def fr_fr(self, fr_fr: str) -> "I18nTextBuilder":
        self._i18n_text.fr_fr = fr_fr
        return self

    def it_it(self, it_it: str) -> "I18nTextBuilder":
        self._i18n_text.it_it = it_it
        return self

    def de_de(self, de_de: str) -> "I18nTextBuilder":
        self._i18n_text.de_de = de_de
        return self

    def ru_ru(self, ru_ru: str) -> "I18nTextBuilder":
        self._i18n_text.ru_ru = ru_ru
        return self

    def th_th(self, th_th: str) -> "I18nTextBuilder":
        self._i18n_text.th_th = th_th
        return self

    def es_es(self, es_es: str) -> "I18nTextBuilder":
        self._i18n_text.es_es = es_es
        return self

    def ko_kr(self, ko_kr: str) -> "I18nTextBuilder":
        self._i18n_text.ko_kr = ko_kr
        return self

    def build(self) -> "I18nText":
        return self._i18n_text
