# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class InputOption(object):
    _types = {
        "name": str,
        "color_index": int,
        "insert_before": str,
        "insert_after": str,
        "is_hidden": bool,
    }

    def __init__(self, d=None):
        self.name: Optional[str] = None
        self.color_index: Optional[int] = None
        self.insert_before: Optional[str] = None
        self.insert_after: Optional[str] = None
        self.is_hidden: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "InputOptionBuilder":
        return InputOptionBuilder()


class InputOptionBuilder(object):
    def __init__(self) -> None:
        self._input_option = InputOption()

    def name(self, name: str) -> "InputOptionBuilder":
        self._input_option.name = name
        return self

    def color_index(self, color_index: int) -> "InputOptionBuilder":
        self._input_option.color_index = color_index
        return self

    def insert_before(self, insert_before: str) -> "InputOptionBuilder":
        self._input_option.insert_before = insert_before
        return self

    def insert_after(self, insert_after: str) -> "InputOptionBuilder":
        self._input_option.insert_after = insert_after
        return self

    def is_hidden(self, is_hidden: bool) -> "InputOptionBuilder":
        self._input_option.is_hidden = is_hidden
        return self

    def build(self) -> "InputOption":
        return self._input_option
