# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .custom_complete import CustomComplete
from .docx_source import DocxSource
from .due import Due
from .input_custom_field_value import InputCustomFieldValue
from .member import Member
from .origin import Origin
from .reminder import Reminder
from .start import Start
from .task_in_tasklist_info import TaskInTasklistInfo


class InputTask(object):
    _types = {
        "summary": str,
        "description": str,
        "due": Due,
        "origin": Origin,
        "extra": str,
        "completed_at": int,
        "members": List[Member],
        "repeat_rule": str,
        "custom_complete": CustomComplete,
        "tasklists": List[TaskInTasklistInfo],
        "client_token": str,
        "start": Start,
        "reminders": List[Reminder],
        "mode": int,
        "is_milestone": bool,
        "custom_fields": List[InputCustomFieldValue],
        "docx_source": DocxSource,
    }

    def __init__(self, d=None):
        self.summary: Optional[str] = None
        self.description: Optional[str] = None
        self.due: Optional[Due] = None
        self.origin: Optional[Origin] = None
        self.extra: Optional[str] = None
        self.completed_at: Optional[int] = None
        self.members: Optional[List[Member]] = None
        self.repeat_rule: Optional[str] = None
        self.custom_complete: Optional[CustomComplete] = None
        self.tasklists: Optional[List[TaskInTasklistInfo]] = None
        self.client_token: Optional[str] = None
        self.start: Optional[Start] = None
        self.reminders: Optional[List[Reminder]] = None
        self.mode: Optional[int] = None
        self.is_milestone: Optional[bool] = None
        self.custom_fields: Optional[List[InputCustomFieldValue]] = None
        self.docx_source: Optional[DocxSource] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "InputTaskBuilder":
        return InputTaskBuilder()


class InputTaskBuilder(object):
    def __init__(self) -> None:
        self._input_task = InputTask()

    def summary(self, summary: str) -> "InputTaskBuilder":
        self._input_task.summary = summary
        return self

    def description(self, description: str) -> "InputTaskBuilder":
        self._input_task.description = description
        return self

    def due(self, due: Due) -> "InputTaskBuilder":
        self._input_task.due = due
        return self

    def origin(self, origin: Origin) -> "InputTaskBuilder":
        self._input_task.origin = origin
        return self

    def extra(self, extra: str) -> "InputTaskBuilder":
        self._input_task.extra = extra
        return self

    def completed_at(self, completed_at: int) -> "InputTaskBuilder":
        self._input_task.completed_at = completed_at
        return self

    def members(self, members: List[Member]) -> "InputTaskBuilder":
        self._input_task.members = members
        return self

    def repeat_rule(self, repeat_rule: str) -> "InputTaskBuilder":
        self._input_task.repeat_rule = repeat_rule
        return self

    def custom_complete(self, custom_complete: CustomComplete) -> "InputTaskBuilder":
        self._input_task.custom_complete = custom_complete
        return self

    def tasklists(self, tasklists: List[TaskInTasklistInfo]) -> "InputTaskBuilder":
        self._input_task.tasklists = tasklists
        return self

    def client_token(self, client_token: str) -> "InputTaskBuilder":
        self._input_task.client_token = client_token
        return self

    def start(self, start: Start) -> "InputTaskBuilder":
        self._input_task.start = start
        return self

    def reminders(self, reminders: List[Reminder]) -> "InputTaskBuilder":
        self._input_task.reminders = reminders
        return self

    def mode(self, mode: int) -> "InputTaskBuilder":
        self._input_task.mode = mode
        return self

    def is_milestone(self, is_milestone: bool) -> "InputTaskBuilder":
        self._input_task.is_milestone = is_milestone
        return self

    def custom_fields(self, custom_fields: List[InputCustomFieldValue]) -> "InputTaskBuilder":
        self._input_task.custom_fields = custom_fields
        return self

    def docx_source(self, docx_source: DocxSource) -> "InputTaskBuilder":
        self._input_task.docx_source = docx_source
        return self

    def build(self) -> "InputTask":
        return self._input_task
