# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListAttachmentRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.page_size: Optional[int] = None
        self.page_token: Optional[str] = None
        self.resource_type: Optional[str] = None
        self.resource_id: Optional[str] = None
        self.user_id_type: Optional[str] = None

    @staticmethod
    def builder() -> "ListAttachmentRequestBuilder":
        return ListAttachmentRequestBuilder()


class ListAttachmentRequestBuilder(object):

    def __init__(self) -> None:
        list_attachment_request = ListAttachmentRequest()
        list_attachment_request.http_method = HttpMethod.GET
        list_attachment_request.uri = "/open-apis/task/v2/attachments"
        list_attachment_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._list_attachment_request: ListAttachmentRequest = list_attachment_request

    def page_size(self, page_size: int) -> "ListAttachmentRequestBuilder":
        self._list_attachment_request.page_size = page_size
        self._list_attachment_request.add_query("page_size", page_size)
        return self

    def page_token(self, page_token: str) -> "ListAttachmentRequestBuilder":
        self._list_attachment_request.page_token = page_token
        self._list_attachment_request.add_query("page_token", page_token)
        return self

    def resource_type(self, resource_type: str) -> "ListAttachmentRequestBuilder":
        self._list_attachment_request.resource_type = resource_type
        self._list_attachment_request.add_query("resource_type", resource_type)
        return self

    def resource_id(self, resource_id: str) -> "ListAttachmentRequestBuilder":
        self._list_attachment_request.resource_id = resource_id
        self._list_attachment_request.add_query("resource_id", resource_id)
        return self

    def user_id_type(self, user_id_type: str) -> "ListAttachmentRequestBuilder":
        self._list_attachment_request.user_id_type = user_id_type
        self._list_attachment_request.add_query("user_id_type", user_id_type)
        return self

    def build(self) -> ListAttachmentRequest:
        return self._list_attachment_request
