# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .attachment import Attachment


class ListAttachmentResponseBody(object):
    _types = {
        "items": List[Attachment],
        "page_token": str,
        "has_more": bool,
    }

    def __init__(self, d=None):
        self.items: Optional[List[Attachment]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListAttachmentResponseBodyBuilder":
        return ListAttachmentResponseBodyBuilder()


class ListAttachmentResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_attachment_response_body = ListAttachmentResponseBody()

    def items(self, items: List[Attachment]) -> "ListAttachmentResponseBodyBuilder":
        self._list_attachment_response_body.items = items
        return self

    def page_token(self, page_token: str) -> "ListAttachmentResponseBodyBuilder":
        self._list_attachment_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "ListAttachmentResponseBodyBuilder":
        self._list_attachment_response_body.has_more = has_more
        return self

    def build(self) -> "ListAttachmentResponseBody":
        return self._list_attachment_response_body
