# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .custom_field import CustomField


class ListCustomFieldResponseBody(object):
    _types = {
        "items": List[CustomField],
        "page_token": str,
        "has_more": bool,
    }

    def __init__(self, d=None):
        self.items: Optional[List[CustomField]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListCustomFieldResponseBodyBuilder":
        return ListCustomFieldResponseBodyBuilder()


class ListCustomFieldResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_custom_field_response_body = ListCustomFieldResponseBody()

    def items(self, items: List[CustomField]) -> "ListCustomFieldResponseBodyBuilder":
        self._list_custom_field_response_body.items = items
        return self

    def page_token(self, page_token: str) -> "ListCustomFieldResponseBodyBuilder":
        self._list_custom_field_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "ListCustomFieldResponseBodyBuilder":
        self._list_custom_field_response_body.has_more = has_more
        return self

    def build(self) -> "ListCustomFieldResponseBody":
        return self._list_custom_field_response_body
