# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .section_summary import SectionSummary


class ListSectionResponseBody(object):
    _types = {
        "items": List[SectionSummary],
        "page_token": str,
        "has_more": bool,
    }

    def __init__(self, d=None):
        self.items: Optional[List[SectionSummary]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListSectionResponseBodyBuilder":
        return ListSectionResponseBodyBuilder()


class ListSectionResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_section_response_body = ListSectionResponseBody()

    def items(self, items: List[SectionSummary]) -> "ListSectionResponseBodyBuilder":
        self._list_section_response_body.items = items
        return self

    def page_token(self, page_token: str) -> "ListSectionResponseBodyBuilder":
        self._list_section_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "ListSectionResponseBodyBuilder":
        self._list_section_response_body.has_more = has_more
        return self

    def build(self) -> "ListSectionResponseBody":
        return self._list_section_response_body
