# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .tasklist import Tasklist


class ListTasklistResponseBody(object):
    _types = {
        "items": List[Tasklist],
        "page_token": str,
        "has_more": bool,
    }

    def __init__(self, d=None):
        self.items: Optional[List[Tasklist]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListTasklistResponseBodyBuilder":
        return ListTasklistResponseBodyBuilder()


class ListTasklistResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_tasklist_response_body = ListTasklistResponseBody()

    def items(self, items: List[Tasklist]) -> "ListTasklistResponseBodyBuilder":
        self._list_tasklist_response_body.items = items
        return self

    def page_token(self, page_token: str) -> "ListTasklistResponseBodyBuilder":
        self._list_tasklist_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "ListTasklistResponseBodyBuilder":
        self._list_tasklist_response_body.has_more = has_more
        return self

    def build(self) -> "ListTasklistResponseBody":
        return self._list_tasklist_response_body
