# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class Member(object):
    _types = {
        "id": str,
        "type": str,
        "role": str,
        "name": str,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.type: Optional[str] = None
        self.role: Optional[str] = None
        self.name: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MemberBuilder":
        return MemberBuilder()


class MemberBuilder(object):
    def __init__(self) -> None:
        self._member = Member()

    def id(self, id: str) -> "MemberBuilder":
        self._member.id = id
        return self

    def type(self, type: str) -> "MemberBuilder":
        self._member.type = type
        return self

    def role(self, role: str) -> "MemberBuilder":
        self._member.role = role
        return self

    def name(self, name: str) -> "MemberBuilder":
        self._member.name = name
        return self

    def build(self) -> "Member":
        return self._member
