# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class Option(object):
    _types = {
        "guid": str,
        "name": str,
        "color_index": int,
        "is_hidden": bool,
    }

    def __init__(self, d=None):
        self.guid: Optional[str] = None
        self.name: Optional[str] = None
        self.color_index: Optional[int] = None
        self.is_hidden: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "OptionBuilder":
        return OptionBuilder()


class OptionBuilder(object):
    def __init__(self) -> None:
        self._option = Option()

    def guid(self, guid: str) -> "OptionBuilder":
        self._option.guid = guid
        return self

    def name(self, name: str) -> "OptionBuilder":
        self._option.name = name
        return self

    def color_index(self, color_index: int) -> "OptionBuilder":
        self._option.color_index = color_index
        return self

    def is_hidden(self, is_hidden: bool) -> "OptionBuilder":
        self._option.is_hidden = is_hidden
        return self

    def build(self) -> "Option":
        return self._option
