# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .href import Href
from .i18n_text import I18nText


class Origin(object):
    _types = {
        "platform_i18n_name": I18nText,
        "href": Href,
    }

    def __init__(self, d=None):
        self.platform_i18n_name: Optional[I18nText] = None
        self.href: Optional[Href] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "OriginBuilder":
        return OriginBuilder()


class OriginBuilder(object):
    def __init__(self) -> None:
        self._origin = Origin()

    def platform_i18n_name(self, platform_i18n_name: I18nText) -> "OriginBuilder":
        self._origin.platform_i18n_name = platform_i18n_name
        return self

    def href(self, href: Href) -> "OriginBuilder":
        self._origin.href = href
        return self

    def build(self) -> "Origin":
        return self._origin
