# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .patch_comment_request_body import PatchCommentRequestBody


class PatchCommentRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.comment_id: Optional[str] = None
        self.request_body: Optional[PatchCommentRequestBody] = None

    @staticmethod
    def builder() -> "PatchCommentRequestBuilder":
        return PatchCommentRequestBuilder()


class PatchCommentRequestBuilder(object):

    def __init__(self) -> None:
        patch_comment_request = PatchCommentRequest()
        patch_comment_request.http_method = HttpMethod.PATCH
        patch_comment_request.uri = "/open-apis/task/v2/comments/:comment_id"
        patch_comment_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._patch_comment_request: PatchCommentRequest = patch_comment_request

    def user_id_type(self, user_id_type: str) -> "PatchCommentRequestBuilder":
        self._patch_comment_request.user_id_type = user_id_type
        self._patch_comment_request.add_query("user_id_type", user_id_type)
        return self

    def comment_id(self, comment_id: str) -> "PatchCommentRequestBuilder":
        self._patch_comment_request.comment_id = comment_id
        self._patch_comment_request.paths["comment_id"] = str(comment_id)
        return self

    def request_body(self, request_body: PatchCommentRequestBody) -> "PatchCommentRequestBuilder":
        self._patch_comment_request.request_body = request_body
        self._patch_comment_request.body = request_body
        return self

    def build(self) -> PatchCommentRequest:
        return self._patch_comment_request
