# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .patch_custom_field_option_request_body import PatchCustomFieldOptionRequestBody


class PatchCustomFieldOptionRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.custom_field_guid: Optional[str] = None
        self.option_guid: Optional[str] = None
        self.request_body: Optional[PatchCustomFieldOptionRequestBody] = None

    @staticmethod
    def builder() -> "PatchCustomFieldOptionRequestBuilder":
        return PatchCustomFieldOptionRequestBuilder()


class PatchCustomFieldOptionRequestBuilder(object):

    def __init__(self) -> None:
        patch_custom_field_option_request = PatchCustomFieldOptionRequest()
        patch_custom_field_option_request.http_method = HttpMethod.PATCH
        patch_custom_field_option_request.uri = "/open-apis/task/v2/custom_fields/:custom_field_guid/options/:option_guid"
        patch_custom_field_option_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._patch_custom_field_option_request: PatchCustomFieldOptionRequest = patch_custom_field_option_request

    def custom_field_guid(self, custom_field_guid: str) -> "PatchCustomFieldOptionRequestBuilder":
        self._patch_custom_field_option_request.custom_field_guid = custom_field_guid
        self._patch_custom_field_option_request.paths["custom_field_guid"] = str(custom_field_guid)
        return self

    def option_guid(self, option_guid: str) -> "PatchCustomFieldOptionRequestBuilder":
        self._patch_custom_field_option_request.option_guid = option_guid
        self._patch_custom_field_option_request.paths["option_guid"] = str(option_guid)
        return self

    def request_body(self, request_body: PatchCustomFieldOptionRequestBody) -> "PatchCustomFieldOptionRequestBuilder":
        self._patch_custom_field_option_request.request_body = request_body
        self._patch_custom_field_option_request.body = request_body
        return self

    def build(self) -> PatchCustomFieldOptionRequest:
        return self._patch_custom_field_option_request
