# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .input_option import InputOption


class PatchCustomFieldOptionRequestBody(object):
    _types = {
        "option": InputOption,
        "update_fields": List[str],
    }

    def __init__(self, d=None):
        self.option: Optional[InputOption] = None
        self.update_fields: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "PatchCustomFieldOptionRequestBodyBuilder":
        return PatchCustomFieldOptionRequestBodyBuilder()


class PatchCustomFieldOptionRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._patch_custom_field_option_request_body = PatchCustomFieldOptionRequestBody()

    def option(self, option: InputOption) -> "PatchCustomFieldOptionRequestBodyBuilder":
        self._patch_custom_field_option_request_body.option = option
        return self

    def update_fields(self, update_fields: List[str]) -> "PatchCustomFieldOptionRequestBodyBuilder":
        self._patch_custom_field_option_request_body.update_fields = update_fields
        return self

    def build(self) -> "PatchCustomFieldOptionRequestBody":
        return self._patch_custom_field_option_request_body
