# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .patch_custom_field_request_body import PatchCustomFieldRequestBody


class PatchCustomFieldRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.custom_field_guid: Optional[str] = None
        self.request_body: Optional[PatchCustomFieldRequestBody] = None

    @staticmethod
    def builder() -> "PatchCustomFieldRequestBuilder":
        return PatchCustomFieldRequestBuilder()


class PatchCustomFieldRequestBuilder(object):

    def __init__(self) -> None:
        patch_custom_field_request = PatchCustomFieldRequest()
        patch_custom_field_request.http_method = HttpMethod.PATCH
        patch_custom_field_request.uri = "/open-apis/task/v2/custom_fields/:custom_field_guid"
        patch_custom_field_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._patch_custom_field_request: PatchCustomFieldRequest = patch_custom_field_request

    def user_id_type(self, user_id_type: str) -> "PatchCustomFieldRequestBuilder":
        self._patch_custom_field_request.user_id_type = user_id_type
        self._patch_custom_field_request.add_query("user_id_type", user_id_type)
        return self

    def custom_field_guid(self, custom_field_guid: str) -> "PatchCustomFieldRequestBuilder":
        self._patch_custom_field_request.custom_field_guid = custom_field_guid
        self._patch_custom_field_request.paths["custom_field_guid"] = str(custom_field_guid)
        return self

    def request_body(self, request_body: PatchCustomFieldRequestBody) -> "PatchCustomFieldRequestBuilder":
        self._patch_custom_field_request.request_body = request_body
        self._patch_custom_field_request.body = request_body
        return self

    def build(self) -> PatchCustomFieldRequest:
        return self._patch_custom_field_request
