# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .patch_section_request_body import PatchSectionRequestBody


class PatchSectionRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.section_guid: Optional[str] = None
        self.request_body: Optional[PatchSectionRequestBody] = None

    @staticmethod
    def builder() -> "PatchSectionRequestBuilder":
        return PatchSectionRequestBuilder()


class PatchSectionRequestBuilder(object):

    def __init__(self) -> None:
        patch_section_request = PatchSectionRequest()
        patch_section_request.http_method = HttpMethod.PATCH
        patch_section_request.uri = "/open-apis/task/v2/sections/:section_guid"
        patch_section_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._patch_section_request: PatchSectionRequest = patch_section_request

    def user_id_type(self, user_id_type: str) -> "PatchSectionRequestBuilder":
        self._patch_section_request.user_id_type = user_id_type
        self._patch_section_request.add_query("user_id_type", user_id_type)
        return self

    def section_guid(self, section_guid: str) -> "PatchSectionRequestBuilder":
        self._patch_section_request.section_guid = section_guid
        self._patch_section_request.paths["section_guid"] = str(section_guid)
        return self

    def request_body(self, request_body: PatchSectionRequestBody) -> "PatchSectionRequestBuilder":
        self._patch_section_request.request_body = request_body
        self._patch_section_request.body = request_body
        return self

    def build(self) -> PatchSectionRequest:
        return self._patch_section_request
