# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .input_section import InputSection


class PatchSectionRequestBody(object):
    _types = {
        "section": InputSection,
        "update_fields": List[str],
    }

    def __init__(self, d=None):
        self.section: Optional[InputSection] = None
        self.update_fields: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "PatchSectionRequestBodyBuilder":
        return PatchSectionRequestBodyBuilder()


class PatchSectionRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._patch_section_request_body = PatchSectionRequestBody()

    def section(self, section: InputSection) -> "PatchSectionRequestBodyBuilder":
        self._patch_section_request_body.section = section
        return self

    def update_fields(self, update_fields: List[str]) -> "PatchSectionRequestBodyBuilder":
        self._patch_section_request_body.update_fields = update_fields
        return self

    def build(self) -> "PatchSectionRequestBody":
        return self._patch_section_request_body
