# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .patch_tasklist_activity_subscription_request_body import PatchTasklistActivitySubscriptionRequestBody


class PatchTasklistActivitySubscriptionRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.tasklist_guid: Optional[str] = None
        self.activity_subscription_guid: Optional[str] = None
        self.request_body: Optional[PatchTasklistActivitySubscriptionRequestBody] = None

    @staticmethod
    def builder() -> "PatchTasklistActivitySubscriptionRequestBuilder":
        return PatchTasklistActivitySubscriptionRequestBuilder()


class PatchTasklistActivitySubscriptionRequestBuilder(object):

    def __init__(self) -> None:
        patch_tasklist_activity_subscription_request = PatchTasklistActivitySubscriptionRequest()
        patch_tasklist_activity_subscription_request.http_method = HttpMethod.PATCH
        patch_tasklist_activity_subscription_request.uri = "/open-apis/task/v2/tasklists/:tasklist_guid/activity_subscriptions/:activity_subscription_guid"
        patch_tasklist_activity_subscription_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._patch_tasklist_activity_subscription_request: PatchTasklistActivitySubscriptionRequest = patch_tasklist_activity_subscription_request

    def user_id_type(self, user_id_type: str) -> "PatchTasklistActivitySubscriptionRequestBuilder":
        self._patch_tasklist_activity_subscription_request.user_id_type = user_id_type
        self._patch_tasklist_activity_subscription_request.add_query("user_id_type", user_id_type)
        return self

    def tasklist_guid(self, tasklist_guid: str) -> "PatchTasklistActivitySubscriptionRequestBuilder":
        self._patch_tasklist_activity_subscription_request.tasklist_guid = tasklist_guid
        self._patch_tasklist_activity_subscription_request.paths["tasklist_guid"] = str(tasklist_guid)
        return self

    def activity_subscription_guid(self,
                                   activity_subscription_guid: str) -> "PatchTasklistActivitySubscriptionRequestBuilder":
        self._patch_tasklist_activity_subscription_request.activity_subscription_guid = activity_subscription_guid
        self._patch_tasklist_activity_subscription_request.paths["activity_subscription_guid"] = str(
            activity_subscription_guid)
        return self

    def request_body(self,
                     request_body: PatchTasklistActivitySubscriptionRequestBody) -> "PatchTasklistActivitySubscriptionRequestBuilder":
        self._patch_tasklist_activity_subscription_request.request_body = request_body
        self._patch_tasklist_activity_subscription_request.body = request_body
        return self

    def build(self) -> PatchTasklistActivitySubscriptionRequest:
        return self._patch_tasklist_activity_subscription_request
