# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .patch_tasklist_request_body import PatchTasklistRequestBody


class PatchTasklistRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.tasklist_guid: Optional[str] = None
        self.request_body: Optional[PatchTasklistRequestBody] = None

    @staticmethod
    def builder() -> "PatchTasklistRequestBuilder":
        return PatchTasklistRequestBuilder()


class PatchTasklistRequestBuilder(object):

    def __init__(self) -> None:
        patch_tasklist_request = PatchTasklistRequest()
        patch_tasklist_request.http_method = HttpMethod.PATCH
        patch_tasklist_request.uri = "/open-apis/task/v2/tasklists/:tasklist_guid"
        patch_tasklist_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._patch_tasklist_request: PatchTasklistRequest = patch_tasklist_request

    def user_id_type(self, user_id_type: str) -> "PatchTasklistRequestBuilder":
        self._patch_tasklist_request.user_id_type = user_id_type
        self._patch_tasklist_request.add_query("user_id_type", user_id_type)
        return self

    def tasklist_guid(self, tasklist_guid: str) -> "PatchTasklistRequestBuilder":
        self._patch_tasklist_request.tasklist_guid = tasklist_guid
        self._patch_tasklist_request.paths["tasklist_guid"] = str(tasklist_guid)
        return self

    def request_body(self, request_body: PatchTasklistRequestBody) -> "PatchTasklistRequestBuilder":
        self._patch_tasklist_request.request_body = request_body
        self._patch_tasklist_request.body = request_body
        return self

    def build(self) -> PatchTasklistRequest:
        return self._patch_tasklist_request
