# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .member import Member
from .tasklist_summary import TasklistSummary


class Section(object):
    _types = {
        "guid": str,
        "name": str,
        "resource_type": str,
        "is_default": bool,
        "creator": Member,
        "tasklist": TasklistSummary,
        "created_at": int,
        "updated_at": int,
    }

    def __init__(self, d=None):
        self.guid: Optional[str] = None
        self.name: Optional[str] = None
        self.resource_type: Optional[str] = None
        self.is_default: Optional[bool] = None
        self.creator: Optional[Member] = None
        self.tasklist: Optional[TasklistSummary] = None
        self.created_at: Optional[int] = None
        self.updated_at: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SectionBuilder":
        return SectionBuilder()


class SectionBuilder(object):
    def __init__(self) -> None:
        self._section = Section()

    def guid(self, guid: str) -> "SectionBuilder":
        self._section.guid = guid
        return self

    def name(self, name: str) -> "SectionBuilder":
        self._section.name = name
        return self

    def resource_type(self, resource_type: str) -> "SectionBuilder":
        self._section.resource_type = resource_type
        return self

    def is_default(self, is_default: bool) -> "SectionBuilder":
        self._section.is_default = is_default
        return self

    def creator(self, creator: Member) -> "SectionBuilder":
        self._section.creator = creator
        return self

    def tasklist(self, tasklist: TasklistSummary) -> "SectionBuilder":
        self._section.tasklist = tasklist
        return self

    def created_at(self, created_at: int) -> "SectionBuilder":
        self._section.created_at = created_at
        return self

    def updated_at(self, updated_at: int) -> "SectionBuilder":
        self._section.updated_at = updated_at
        return self

    def build(self) -> "Section":
        return self._section
