# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .attachment import Attachment
from .custom_complete import CustomComplete
from .custom_field_value import CustomFieldValue
from .due import Due
from .member import Member
from .origin import Origin
from .reminder import Reminder
from .start import Start
from .task_dependency import TaskDependency
from .task_in_tasklist_info import TaskInTasklistInfo


class Task(object):
    _types = {
        "guid": str,
        "summary": str,
        "description": str,
        "due": Due,
        "reminders": List[Reminder],
        "creator": Member,
        "members": List[Member],
        "completed_at": int,
        "attachments": List[Attachment],
        "origin": Origin,
        "extra": str,
        "tasklists": List[TaskInTasklistInfo],
        "repeat_rule": str,
        "parent_task_guid": str,
        "mode": int,
        "source": int,
        "custom_complete": CustomComplete,
        "task_id": str,
        "created_at": int,
        "updated_at": int,
        "status": str,
        "url": str,
        "start": Start,
        "subtask_count": int,
        "is_milestone": bool,
        "custom_fields": List[CustomFieldValue],
        "dependencies": List[TaskDependency],
    }

    def __init__(self, d=None):
        self.guid: Optional[str] = None
        self.summary: Optional[str] = None
        self.description: Optional[str] = None
        self.due: Optional[Due] = None
        self.reminders: Optional[List[Reminder]] = None
        self.creator: Optional[Member] = None
        self.members: Optional[List[Member]] = None
        self.completed_at: Optional[int] = None
        self.attachments: Optional[List[Attachment]] = None
        self.origin: Optional[Origin] = None
        self.extra: Optional[str] = None
        self.tasklists: Optional[List[TaskInTasklistInfo]] = None
        self.repeat_rule: Optional[str] = None
        self.parent_task_guid: Optional[str] = None
        self.mode: Optional[int] = None
        self.source: Optional[int] = None
        self.custom_complete: Optional[CustomComplete] = None
        self.task_id: Optional[str] = None
        self.created_at: Optional[int] = None
        self.updated_at: Optional[int] = None
        self.status: Optional[str] = None
        self.url: Optional[str] = None
        self.start: Optional[Start] = None
        self.subtask_count: Optional[int] = None
        self.is_milestone: Optional[bool] = None
        self.custom_fields: Optional[List[CustomFieldValue]] = None
        self.dependencies: Optional[List[TaskDependency]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TaskBuilder":
        return TaskBuilder()


class TaskBuilder(object):
    def __init__(self) -> None:
        self._task = Task()

    def guid(self, guid: str) -> "TaskBuilder":
        self._task.guid = guid
        return self

    def summary(self, summary: str) -> "TaskBuilder":
        self._task.summary = summary
        return self

    def description(self, description: str) -> "TaskBuilder":
        self._task.description = description
        return self

    def due(self, due: Due) -> "TaskBuilder":
        self._task.due = due
        return self

    def reminders(self, reminders: List[Reminder]) -> "TaskBuilder":
        self._task.reminders = reminders
        return self

    def creator(self, creator: Member) -> "TaskBuilder":
        self._task.creator = creator
        return self

    def members(self, members: List[Member]) -> "TaskBuilder":
        self._task.members = members
        return self

    def completed_at(self, completed_at: int) -> "TaskBuilder":
        self._task.completed_at = completed_at
        return self

    def attachments(self, attachments: List[Attachment]) -> "TaskBuilder":
        self._task.attachments = attachments
        return self

    def origin(self, origin: Origin) -> "TaskBuilder":
        self._task.origin = origin
        return self

    def extra(self, extra: str) -> "TaskBuilder":
        self._task.extra = extra
        return self

    def tasklists(self, tasklists: List[TaskInTasklistInfo]) -> "TaskBuilder":
        self._task.tasklists = tasklists
        return self

    def repeat_rule(self, repeat_rule: str) -> "TaskBuilder":
        self._task.repeat_rule = repeat_rule
        return self

    def parent_task_guid(self, parent_task_guid: str) -> "TaskBuilder":
        self._task.parent_task_guid = parent_task_guid
        return self

    def mode(self, mode: int) -> "TaskBuilder":
        self._task.mode = mode
        return self

    def source(self, source: int) -> "TaskBuilder":
        self._task.source = source
        return self

    def custom_complete(self, custom_complete: CustomComplete) -> "TaskBuilder":
        self._task.custom_complete = custom_complete
        return self

    def task_id(self, task_id: str) -> "TaskBuilder":
        self._task.task_id = task_id
        return self

    def created_at(self, created_at: int) -> "TaskBuilder":
        self._task.created_at = created_at
        return self

    def updated_at(self, updated_at: int) -> "TaskBuilder":
        self._task.updated_at = updated_at
        return self

    def status(self, status: str) -> "TaskBuilder":
        self._task.status = status
        return self

    def url(self, url: str) -> "TaskBuilder":
        self._task.url = url
        return self

    def start(self, start: Start) -> "TaskBuilder":
        self._task.start = start
        return self

    def subtask_count(self, subtask_count: int) -> "TaskBuilder":
        self._task.subtask_count = subtask_count
        return self

    def is_milestone(self, is_milestone: bool) -> "TaskBuilder":
        self._task.is_milestone = is_milestone
        return self

    def custom_fields(self, custom_fields: List[CustomFieldValue]) -> "TaskBuilder":
        self._task.custom_fields = custom_fields
        return self

    def dependencies(self, dependencies: List[TaskDependency]) -> "TaskBuilder":
        self._task.dependencies = dependencies
        return self

    def build(self) -> "Task":
        return self._task
