# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class TaskStatistics(object):
    _types = {
        "total_tasks_count": int,
        "total_completed_tasks_count": int,
        "total_uncompleted_tasks_count": int,
    }

    def __init__(self, d=None):
        self.total_tasks_count: Optional[int] = None
        self.total_completed_tasks_count: Optional[int] = None
        self.total_uncompleted_tasks_count: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TaskStatisticsBuilder":
        return TaskStatisticsBuilder()


class TaskStatisticsBuilder(object):
    def __init__(self) -> None:
        self._task_statistics = TaskStatistics()

    def total_tasks_count(self, total_tasks_count: int) -> "TaskStatisticsBuilder":
        self._task_statistics.total_tasks_count = total_tasks_count
        return self

    def total_completed_tasks_count(self, total_completed_tasks_count: int) -> "TaskStatisticsBuilder":
        self._task_statistics.total_completed_tasks_count = total_completed_tasks_count
        return self

    def total_uncompleted_tasks_count(self, total_uncompleted_tasks_count: int) -> "TaskStatisticsBuilder":
        self._task_statistics.total_uncompleted_tasks_count = total_uncompleted_tasks_count
        return self

    def build(self) -> "TaskStatistics":
        return self._task_statistics
