# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .due import Due
from .member import Member
from .start import Start


class TaskSummary(object):
    _types = {
        "guid": str,
        "summary": str,
        "completed_at": int,
        "start": Start,
        "due": Due,
        "members": List[Member],
        "subtask_count": int,
    }

    def __init__(self, d=None):
        self.guid: Optional[str] = None
        self.summary: Optional[str] = None
        self.completed_at: Optional[int] = None
        self.start: Optional[Start] = None
        self.due: Optional[Due] = None
        self.members: Optional[List[Member]] = None
        self.subtask_count: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TaskSummaryBuilder":
        return TaskSummaryBuilder()


class TaskSummaryBuilder(object):
    def __init__(self) -> None:
        self._task_summary = TaskSummary()

    def guid(self, guid: str) -> "TaskSummaryBuilder":
        self._task_summary.guid = guid
        return self

    def summary(self, summary: str) -> "TaskSummaryBuilder":
        self._task_summary.summary = summary
        return self

    def completed_at(self, completed_at: int) -> "TaskSummaryBuilder":
        self._task_summary.completed_at = completed_at
        return self

    def start(self, start: Start) -> "TaskSummaryBuilder":
        self._task_summary.start = start
        return self

    def due(self, due: Due) -> "TaskSummaryBuilder":
        self._task_summary.due = due
        return self

    def members(self, members: List[Member]) -> "TaskSummaryBuilder":
        self._task_summary.members = members
        return self

    def subtask_count(self, subtask_count: int) -> "TaskSummaryBuilder":
        self._task_summary.subtask_count = subtask_count
        return self

    def build(self) -> "TaskSummary":
        return self._task_summary
