# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .member import Member


class TasklistActivitySubscription(object):
    _types = {
        "guid": str,
        "name": str,
        "subscribers": List[Member],
        "include_keys": List[int],
        "disabled": bool,
    }

    def __init__(self, d=None):
        self.guid: Optional[str] = None
        self.name: Optional[str] = None
        self.subscribers: Optional[List[Member]] = None
        self.include_keys: Optional[List[int]] = None
        self.disabled: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TasklistActivitySubscriptionBuilder":
        return TasklistActivitySubscriptionBuilder()


class TasklistActivitySubscriptionBuilder(object):
    def __init__(self) -> None:
        self._tasklist_activity_subscription = TasklistActivitySubscription()

    def guid(self, guid: str) -> "TasklistActivitySubscriptionBuilder":
        self._tasklist_activity_subscription.guid = guid
        return self

    def name(self, name: str) -> "TasklistActivitySubscriptionBuilder":
        self._tasklist_activity_subscription.name = name
        return self

    def subscribers(self, subscribers: List[Member]) -> "TasklistActivitySubscriptionBuilder":
        self._tasklist_activity_subscription.subscribers = subscribers
        return self

    def include_keys(self, include_keys: List[int]) -> "TasklistActivitySubscriptionBuilder":
        self._tasklist_activity_subscription.include_keys = include_keys
        return self

    def disabled(self, disabled: bool) -> "TasklistActivitySubscriptionBuilder":
        self._tasklist_activity_subscription.disabled = disabled
        return self

    def build(self) -> "TasklistActivitySubscription":
        return self._tasklist_activity_subscription
