# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class TasksTasklistRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.page_size: Optional[int] = None
        self.page_token: Optional[str] = None
        self.completed: Optional[bool] = None
        self.created_from: Optional[int] = None
        self.created_to: Optional[int] = None
        self.user_id_type: Optional[str] = None
        self.tasklist_guid: Optional[str] = None

    @staticmethod
    def builder() -> "TasksTasklistRequestBuilder":
        return TasksTasklistRequestBuilder()


class TasksTasklistRequestBuilder(object):

    def __init__(self) -> None:
        tasks_tasklist_request = TasksTasklistRequest()
        tasks_tasklist_request.http_method = HttpMethod.GET
        tasks_tasklist_request.uri = "/open-apis/task/v2/tasklists/:tasklist_guid/tasks"
        tasks_tasklist_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._tasks_tasklist_request: TasksTasklistRequest = tasks_tasklist_request

    def page_size(self, page_size: int) -> "TasksTasklistRequestBuilder":
        self._tasks_tasklist_request.page_size = page_size
        self._tasks_tasklist_request.add_query("page_size", page_size)
        return self

    def page_token(self, page_token: str) -> "TasksTasklistRequestBuilder":
        self._tasks_tasklist_request.page_token = page_token
        self._tasks_tasklist_request.add_query("page_token", page_token)
        return self

    def completed(self, completed: bool) -> "TasksTasklistRequestBuilder":
        self._tasks_tasklist_request.completed = completed
        self._tasks_tasklist_request.add_query("completed", completed)
        return self

    def created_from(self, created_from: int) -> "TasksTasklistRequestBuilder":
        self._tasks_tasklist_request.created_from = created_from
        self._tasks_tasklist_request.add_query("created_from", created_from)
        return self

    def created_to(self, created_to: int) -> "TasksTasklistRequestBuilder":
        self._tasks_tasklist_request.created_to = created_to
        self._tasks_tasklist_request.add_query("created_to", created_to)
        return self

    def user_id_type(self, user_id_type: str) -> "TasksTasklistRequestBuilder":
        self._tasks_tasklist_request.user_id_type = user_id_type
        self._tasks_tasklist_request.add_query("user_id_type", user_id_type)
        return self

    def tasklist_guid(self, tasklist_guid: str) -> "TasksTasklistRequestBuilder":
        self._tasks_tasklist_request.tasklist_guid = tasklist_guid
        self._tasks_tasklist_request.paths["tasklist_guid"] = str(tasklist_guid)
        return self

    def build(self) -> TasksTasklistRequest:
        return self._tasks_tasklist_request
