# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .task_summary import TaskSummary


class TasksTasklistResponseBody(object):
    _types = {
        "items": List[TaskSummary],
        "page_token": str,
        "has_more": bool,
    }

    def __init__(self, d=None):
        self.items: Optional[List[TaskSummary]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TasksTasklistResponseBodyBuilder":
        return TasksTasklistResponseBodyBuilder()


class TasksTasklistResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._tasks_tasklist_response_body = TasksTasklistResponseBody()

    def items(self, items: List[TaskSummary]) -> "TasksTasklistResponseBodyBuilder":
        self._tasks_tasklist_response_body.items = items
        return self

    def page_token(self, page_token: str) -> "TasksTasklistResponseBodyBuilder":
        self._tasks_tasklist_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "TasksTasklistResponseBodyBuilder":
        self._tasks_tasklist_response_body.has_more = has_more
        return self

    def build(self) -> "TasksTasklistResponseBody":
        return self._tasks_tasklist_response_body
