# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .input_attachment import InputAttachment


class UploadAttachmentRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.request_body: Optional[InputAttachment] = None

    @staticmethod
    def builder() -> "UploadAttachmentRequestBuilder":
        return UploadAttachmentRequestBuilder()


class UploadAttachmentRequestBuilder(object):

    def __init__(self) -> None:
        upload_attachment_request = UploadAttachmentRequest()
        upload_attachment_request.http_method = HttpMethod.POST
        upload_attachment_request.uri = "/open-apis/task/v2/attachments/upload"
        upload_attachment_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._upload_attachment_request: UploadAttachmentRequest = upload_attachment_request

    def user_id_type(self, user_id_type: str) -> "UploadAttachmentRequestBuilder":
        self._upload_attachment_request.user_id_type = user_id_type
        self._upload_attachment_request.add_query("user_id_type", user_id_type)
        return self

    def request_body(self, request_body: InputAttachment) -> "UploadAttachmentRequestBuilder":
        self._upload_attachment_request.request_body = request_body
        self._upload_attachment_request.body = request_body
        return self

    def build(self) -> UploadAttachmentRequest:
        return self._upload_attachment_request
