# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_comment_request import CreateCommentRequest
from ..model.create_comment_response import CreateCommentResponse
from ..model.delete_comment_request import DeleteCommentRequest
from ..model.delete_comment_response import DeleteCommentResponse
from ..model.get_comment_request import GetCommentRequest
from ..model.get_comment_response import GetCommentResponse
from ..model.list_comment_request import ListCommentRequest
from ..model.list_comment_response import ListCommentResponse
from ..model.patch_comment_request import PatchCommentRequest
from ..model.patch_comment_response import PatchCommentResponse


class Comment(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreateCommentRequest, option: Optional[RequestOption] = None) -> CreateCommentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateCommentResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateCommentResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateCommentRequest,
                      option: Optional[RequestOption] = None) -> CreateCommentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateCommentResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateCommentResponse)
        response.raw = resp

        return response

    def delete(self, request: DeleteCommentRequest, option: Optional[RequestOption] = None) -> DeleteCommentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteCommentResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteCommentResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeleteCommentRequest,
                      option: Optional[RequestOption] = None) -> DeleteCommentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteCommentResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteCommentResponse)
        response.raw = resp

        return response

    def get(self, request: GetCommentRequest, option: Optional[RequestOption] = None) -> GetCommentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetCommentResponse = JSON.unmarshal(str(resp.content, UTF_8), GetCommentResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetCommentRequest, option: Optional[RequestOption] = None) -> GetCommentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetCommentResponse = JSON.unmarshal(str(resp.content, UTF_8), GetCommentResponse)
        response.raw = resp

        return response

    def list(self, request: ListCommentRequest, option: Optional[RequestOption] = None) -> ListCommentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListCommentResponse = JSON.unmarshal(str(resp.content, UTF_8), ListCommentResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListCommentRequest, option: Optional[RequestOption] = None) -> ListCommentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListCommentResponse = JSON.unmarshal(str(resp.content, UTF_8), ListCommentResponse)
        response.raw = resp

        return response

    def patch(self, request: PatchCommentRequest, option: Optional[RequestOption] = None) -> PatchCommentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: PatchCommentResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchCommentResponse)
        response.raw = resp

        return response

    async def apatch(self, request: PatchCommentRequest,
                     option: Optional[RequestOption] = None) -> PatchCommentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: PatchCommentResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchCommentResponse)
        response.raw = resp

        return response
